
#ifndef SST_TST_ATP_ITERATORS_H
#define SST_TST_ATP_ITERATORS_H
#if TST_USE_ITERTOR_MODULE
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_Iterators.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/*Authenticator test struct*/
typedef struct TST_ATP_IteratorTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxUint8_t                   TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataSize;
} TST_ATP_IteratorTestDataStruct;

/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
* Function Name:                                                           
*  SST_TST_ATP_Iterator         
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* Test the iteration services  begin, increment and get, decrement and get, get all handles and terminate operations
*  
* Algorithm:       
*    1.  Create a new session by calling: SST_SessionCreate.
*    2.  Open a transaction by calling: SST_TransactionStart.
*    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    4.  Close the transaction by calling: SST_TransactionEnd.
*    5.  Open the password authenticator by calling: SST_AuthenticationOpen.
*    6.  Open a transaction by calling: SST_TransactionStart.
*    7.  Insert a new data objects 1~4 (type: simple data) by calling: SST_InsertData.
*    8.  Generate a new AES 1~2 (type: AES_key) key by calling: SST_AESKeyGenerate.
*    9.  Generate a new DES (type: DES_key) key by calling: SST_DESKeyGenerate.
*    10.   Create a new iterator #1 by calling: SST_TypeIteratorBegin. With the simple data handle 
*    11.   Get the current iteration handle by calling: SST_TypeIteratorCurrentGet. And verify its a valid handle.
*    12.   Get the previous iteration handle by calling by calling: SST_TypeIteratorHandleIncAndGet. And verify its a valid handle.
*    13.   Get the previous iteration handle by calling: SST_TypeIteratorHandleDecAndGet. And verify its a valid handle.
*    14.   Create an iterator #1 again to reset  by calling: SST_TypeIteratorBegin.
*    15.   Get all available handles by calling: SST_TypeIteratorHandlesGet and verify you get only 4 handles
*    16.   Create a new iterator #2 by calling: SST_TypeIteratorBegin. With the AES key data handle.
*    17.   Create a new iterator #3 by calling: SST_TypeIteratorBegin. With the DES key data handle.
*    18.   Get all available AES key handles by calling: SST_TypeIteratorHandlesGet and verify you get only 2 handles
*    19.   Get all available DES key handles by calling: SST_TypeIteratorHandlesGet and verify you get only 1 handles
*    20.   Delete the iterators (one by one) by calling: SST_TypeIteratorTerminate.
*    21.   Delete all the data objects (one by one) by calling: SST_DataDelete.
*    22.   Delete the authenticator by calling: SST_AuthenticatorDelete.
*    23.   Close the transaction by calling: SST_TransactionEnd.
*    24.   Delete the session by calling: SST_SessionDelete.
*
*******************************************************************************/   
DxError_t SST_TST_ATP_Iterator ( void );


#ifdef __cplusplus
}
#endif

#endif

#endif


